/*
  Demo scene for the fabric texture macros for ArahWeave

  Instructions:

  1) render as provided to generate the cloth mesh
  2) change use_simcloth to 1 to use the generated mesh for next renders
  3) play with the fabric examples, chaging parameters to see the effects
  4) to aleviate mesh artifacts, set use_area to 1

  Note: the fabric images and maps attached were generated with the demo 
  version of ArahWeave, using example fabrics from the program. You can 
  download it from www.arahne.si.

  --
  Jaime Vives Piqueres, Nov.2006
*/


// standard includes
#include "colors.inc"     // for predefined colors
#include "textures.inc"   // for predefined finishes
#include "woods.inc"      // for the table/stand

// render control
#declare use_simcloth=0; // 0=off, 1=generate cloth

// cloth mesh generation with simcloth{}
#include "i_simcloth.inc"

// *****************
// fabric parameters
// *****************
//
/* example 1 :

#declare fabric_img="037tissu.png";     // fabric image
#declare fabric_bmp="brodie-dress-bmp.png"; // bumps map
#declare fabric_map="brodie-dress-map.png"; // yarns map
#declare fabric_map_indexes=3;   // number of indexes on the map
#declare fabric_bump_size=4;     // fabric normal (apparent) height
#declare fabric_scale=.25;       // fabric scale
#declare fabric_solid_colors=0;  // use solid colors or image_map colors
#declare fabric_random_colors=0; // use random colors or suplied ones 
#declare fabric_random_finish=0; // use random finishes or suplied ones
#declare fabric_finish=array[3]; // finishes array
#declare fabric_finish[0]=finish{}
#declare fabric_finish[1]=finish{}
#declare fabric_finish[2]=finish{}
*/
///*
// example 2 :
//#declare fabric_bmp="tissus-bmp.png";     // bumps map
#declare fabric_map="tutorial01-map.png"; // yarns map
#declare fabric_bmp="tissus-bmp.png";//"tutorial01-map.png";     // bumps map
#declare fabric_img="tutorial01-map.png";     // fabric image
//#declare fabric_map="blueroundflowers_tile.png"; // yarns map

#declare fabric_map_indexes=3;   // number of indexes on the map
#declare fabric_bump_size=2;//2;     // fabric normal (apparent) height
#declare fabric_scale=.8;        // fabric scale
#declare fabric_solid_colors=1;  // use solid colors or image_map colors
#declare fabric_random_colors=0; // use random colors or suplied ones 
#if (fabric_random_colors)
 #declare r_fabric_colors=seed(456); // seed for the random colors
#else
 #declare fabric_colors=array[3]; // colors array
 #declare fabric_colors[0]=NavyBlue;//Firebrick;
 #declare fabric_colors[1]=Gold;
 #declare fabric_colors[2]=DarkSlateBlue;//Gold;
#end
#declare fabric_random_finish=0; // use random finishes or suplied ones
#if (fabric_random_finish)
  #declare r_fabric_finish=seed(299); // seed for the random finishes
#else
 #declare fabric_finish=array[3]; // finishes array
 #declare fabric_finish[0]=finish{}
 #declare fabric_finish[1]=finish{specular .33 metallic}
 #declare fabric_finish[2]=finish{specular .63 metallic}
#end
/*
// example 3:
#declare fabric_img="transparent.png";     // fabric image
#declare fabric_bmp="transparent.png";     // bumps map
#declare fabric_map="transparent-map.png"; // yarns map
#declare fabric_map_indexes=4;   // number of indexes on the map
#declare fabric_bump_size=4;     // fabric normal (apparent) height
#declare fabric_scale=.15;       // fabric scale
#declare fabric_solid_colors=1;  // use solid colors or image_map colors
#declare fabric_random_colors=0; // use random colors or suplied ones 
#declare fabric_colors=array[fabric_map_indexes]; // colors array
#declare fabric_colors[0]=White;
#declare fabric_colors[1]=White;
#declare fabric_colors[2]=White;
#declare fabric_colors[3]=Clear;
#declare fabric_random_finish=0; // use random finishes or suplied ones
#declare fabric_finish=array[4]; // finishes array
#declare fabric_finish[0]=finish{}
#declare fabric_finish[1]=finish{}
#declare fabric_finish[2]=finish{}
#declare fabric_finish[3]=finish{}
*/
// build the fabric texture
#include "i_fabric.inc"

// include generated cloth mesh and texture it with the generated fabric
#declare Nappe = mesh {
	#include "drap_s.msh"
	uv_mapping
	texture {t_fabric}
}

